/*************************************************************************
 * The contents of this file are subject to the MYRICOM MYRINET          *
 * EXPRESS (MX) NETWORKING SOFTWARE AND DOCUMENTATION LICENSE (the       *
 * "License"); User may not use this file except in compliance with the  *
 * License.  The full text of the License can found in LICENSE.TXT       *
 *                                                                       *
 * Software distributed under the License is distributed on an "AS IS"   *
 * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied.  See  *
 * the License for the specific language governing rights and            *
 * limitations under the License.                                        *
 *                                                                       *
 * Copyright 2003 - 2004 by Myricom, Inc.  All rights reserved.          *
 *************************************************************************/

#ifndef _mx_ether_h_
#define _mx_ether_h_

#include <sys/param.h>
#include <sys/systm.h>
#include <sys/sockio.h>
#include <sys/mbuf.h>
#include <sys/kernel.h>
#include <sys/socket.h>
#include <net/if_types.h>
#include <net/if.h>
#include <net/if_arp.h>
#include <net/ethernet.h>
#include <net/bpf.h>
#include <net/if_media.h>

struct mx_ether_buffer_info {
	struct mbuf *m;
};


struct mx_ether_arch {
#if (__FreeBSD_version < 600031)
	struct arpcom arpcom;		/* must be first... 		*/
#define is_if   arch.arpcom.ac_if 	/* network-visible interface 	*/
#define is_addr arch.arpcom.ac_enaddr	/* hardware Ethernet address 	*/
#endif
	struct ifnet *ifp;
	struct mtx tx_mtx __aligned(64);/* Transmit lock 		*/
	struct mtx meta_mtx;		/* Ifconfig lock 		*/
	struct ifmedia ifm;		/* for link status, etc 	*/
	char scratch[256 + ETHER_HDR_LEN];
};

#endif /* _mx_ether_h_ */


/* 
 * Shims to work around API/ABI differences in 5.x, 6.x and 7.x 
 */

static inline int
mx_ifp_is_running(struct ifnet *ifp)
{
#ifdef IFF_DRV_RUNNING
	return (ifp->if_drv_flags & IFF_DRV_RUNNING);
#else
	return (ifp->if_flags & IFF_RUNNING);
#endif
}

static inline void
mx_ifp_set_running(struct ifnet *ifp)
{
#ifdef IFF_DRV_RUNNING
	ifp->if_drv_flags |= IFF_DRV_RUNNING;
#else
	ifp->if_flags |= IFF_RUNNING;
#endif
}

static inline void
mx_ifp_clear_running(struct ifnet *ifp)
{
#ifdef IFF_DRV_RUNNING
	ifp->if_drv_flags &= ~IFF_DRV_RUNNING;
#else
	ifp->if_flags &= ~IFF_RUNNING;
#endif
}

static inline int
mx_ifp_is_active(struct ifnet *ifp)
{
#ifdef IFF_DRV_OACTIVE
	return (ifp->if_drv_flags & IFF_DRV_OACTIVE);
#else
	return (ifp->if_flags & IFF_OACTIVE);
#endif
}


static inline void
mx_ifp_set_active(struct ifnet *ifp)
{
#ifdef IFF_DRV_OACTIVE
	ifp->if_drv_flags |= IFF_DRV_OACTIVE;
#else
	ifp->if_flags |= IFF_OACTIVE;
#endif
}

static inline void
mx_ifp_clear_active(struct ifnet *ifp)
{
#ifdef IFF_DRV_OACTIVE
	ifp->if_drv_flags &= ~IFF_DRV_OACTIVE;
#else
	ifp->if_flags &= ~IFF_OACTIVE;
#endif
}




/*
  This file uses MX driver indentation.

  Local Variables:
  c-file-style:"linux"
  tab-width:8
  End:
*/
